package Strategy;

public class Test {
	 public static void main(String[] args) {
	        // Creazione delle strategie
	        Strategy addStrategy = new Add();
	        Strategy subtractStrategy = new Subtract();
	        Strategy multiplyStrategy = new Multiply();

	        // Creazione del contesto con una strategia predefinita (somma)
	        Context context = new Context(addStrategy);

	        // Esecuzione delle operazioni utilizzando la strategia corrente
	        System.out.println("10 + 5 = " + context.executeStrategy(10, 5));

	        // Cambio dinamico della strategia (ora utilizziamo la sottrazione)
	        context.setStrategy(subtractStrategy);
	        System.out.println("10 - 5 = " + context.executeStrategy(10, 5));

	        // Cambio dinamico della strategia (ora utilizziamo la moltiplicazione)
	        context.setStrategy(multiplyStrategy);
	        System.out.println("10 * 5 = " + context.executeStrategy(10, 5));
	        
	        context.setStrategy(new Division());
	        System.out.println("10 / 5 = " + context.executeStrategy(10, 5));
	        
	        
	    }
}
